/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StartupLoggingUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
    private static final String INITIAL_ROOT_LOG_LEVEL = StartupLoggingUtils.getLogLevelString();

    public static void checkLogDir() {
        if (EnvUtils.getProperty((String)"solr.log.dir") == null) {
            log.error("Missing Java Option solr.log.dir. Logging may be missing or incomplete.");
        }
    }

    public static String getLoggerImplStr() {
        return loggerFactory.getClass().getName();
    }

    @SuppressForbidden(reason="Legitimate log4j2 access")
    public static boolean muteConsole() {
        try {
            if (!StartupLoggingUtils.isLog4jActive()) {
                StartupLoggingUtils.logNotSupported("Could not mute logging to console.");
                return false;
            }
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig("");
            Map appenders = loggerConfig.getAppenders();
            appenders.forEach((name, appender) -> {
                if (appender instanceof ConsoleAppender) {
                    loggerConfig.removeAppender(name);
                    ctx.updateLoggers();
                }
            });
            return true;
        }
        catch (Exception e) {
            StartupLoggingUtils.logNotSupported("Could not mute logging to console.");
            return false;
        }
    }

    @SuppressForbidden(reason="Legitimate log4j2 access")
    public static boolean changeLogLevel(String logLevel) {
        try {
            if (!StartupLoggingUtils.isLog4jActive()) {
                StartupLoggingUtils.logNotSupported("Could not change log level.");
                return false;
            }
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getRootLogger();
            loggerConfig.setLevel(Level.toLevel((String)logLevel, (Level)Level.INFO));
            ctx.updateLoggers();
            return true;
        }
        catch (Exception e) {
            StartupLoggingUtils.logNotSupported("Could not change log level.");
            return false;
        }
    }

    private static boolean isLog4jActive() {
        try {
            Class.forName("org.apache.logging.log4j.LogManager");
            return StartupLoggingUtils.getLoggerImplStr().contains("Log4jLoggerFactory");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void logNotSupported(String msg) {
        log.warn("{} Dynamic log manipulation currently only supported for Log4j. Please consult your logging framework of choice on how to configure the appropriate logging.", (Object)msg);
    }

    @SuppressForbidden(reason="Legitimate log4j2 access")
    public static void shutdown() {
        if (!StartupLoggingUtils.isLog4jActive()) {
            StartupLoggingUtils.logNotSupported("Not running log4j2, could not call shutdown for async logging.");
            return;
        }
        StartupLoggingUtils.flushAllLoggers();
        LogManager.shutdown((boolean)true);
        if (!INITIAL_ROOT_LOG_LEVEL.equals(StartupLoggingUtils.getLogLevelString())) {
            StartupLoggingUtils.changeLogLevel(INITIAL_ROOT_LOG_LEVEL);
        }
    }

    @SuppressForbidden(reason="Legitimate log4j2 access")
    public static void flushAllLoggers() {
        if (!StartupLoggingUtils.isLog4jActive()) {
            StartupLoggingUtils.logNotSupported("Not running log4j2, could not call shutdown for async logging.");
            return;
        }
        LoggerContext logCtx = (LoggerContext)LogManager.getContext((boolean)false);
        for (org.apache.logging.log4j.core.Logger logger : logCtx.getLoggers()) {
            for (Appender appender : logger.getAppenders().values()) {
                if (!(appender instanceof AbstractOutputStreamAppender)) continue;
                ((AbstractOutputStreamAppender)appender).getManager().flush();
            }
        }
    }

    public static String getLogLevelString() {
        Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
        if (rootLogger.isTraceEnabled()) {
            return "TRACE";
        }
        if (rootLogger.isDebugEnabled()) {
            return "DEBUG";
        }
        if (rootLogger.isInfoEnabled()) {
            return "INFO";
        }
        if (rootLogger.isWarnEnabled()) {
            return "WARN";
        }
        if (rootLogger.isErrorEnabled()) {
            return "ERROR";
        }
        return "INFO";
    }

    public static void checkRequestLogging() {
        boolean requestLogEnabled = Boolean.getBoolean("solr.log.requestlog.enabled");
        String retainDays = System.getProperty("solr.log.requestlog.retaindays");
        if (requestLogEnabled) {
            if (retainDays == null) {
                log.warn("Jetty request logging enabled. Will retain logs for last 3 days. See chapter \"Configuring Logging\" in reference guide for how to configure.");
            } else {
                log.info("Jetty request logging enabled. Will retain logs for last {} days.", (Object)retainDays);
            }
        }
    }
}

