/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.view.XSelectionSupplier;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NumberFormatter;

public class TextTableHandler {
    public XTextTablesSupplier xTextTablesSupplier;
    private XTextDocument xTextDocument;
    private NumberFormatter oNumberFormatter;

    public TextTableHandler(XTextDocument xTextDocument) {
        try {
            this.xTextDocument = xTextDocument;
            this.xTextTablesSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)xTextDocument);
            UnoRuntime.queryInterface(XSimpleText.class, (Object)xTextDocument.getText());
            XNumberFormatsSupplier xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)xTextDocument);
            Locale locale = (Locale)Helper.getUnoStructValue(xTextDocument, "CharLocale");
            this.oNumberFormatter = new NumberFormatter(xNumberFormatsSupplier, locale);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public NumberFormatter getNumberFormatter() {
        return this.oNumberFormatter;
    }

    public XTextTable getByName(String string) {
        XTextTable xTextTable = null;
        try {
            XNameAccess xNameAccess = this.xTextTablesSupplier.getTextTables();
            if (xNameAccess.hasByName(string)) {
                Object object = xNameAccess.getByName(string);
                xTextTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)object);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
        return xTextTable;
    }

    public XTextTable getlastTextTable() {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextTablesSupplier.getTextTables());
            int n = xIndexAccess.getCount() - 1;
            Object object = xIndexAccess.getByIndex(n);
            return (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)object);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void removeAllTextTables() {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextTablesSupplier.getTextTables());
            int n = xIndexAccess.getCount();
            for (int i = n - 1; i >= 0; --i) {
                this.removeTextTable(xIndexAccess.getByIndex(i));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void removeLastTextTable() {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextTablesSupplier.getTextTables());
            Object object = xIndexAccess.getByIndex(xIndexAccess.getCount() - 1);
            this.removeTextTable(object);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void removeTextTable(Object object) {
        try {
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)object);
            this.xTextDocument.getText().removeTextContent(xTextContent);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void removeTextTablebyName(String string) {
        try {
            XNameAccess xNameAccess = this.xTextTablesSupplier.getTextTables();
            if (xNameAccess.hasByName(string)) {
                this.removeTextTable(xNameAccess.getByName(string));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void renameTextTable(String string, String string2) {
        try {
            XNameAccess xNameAccess = this.xTextTablesSupplier.getTextTables();
            if (xNameAccess.hasByName(string)) {
                Object object = xNameAccess.getByName(string);
                XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)object);
                xNamed.setName(string2);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void adjustOptimalTableWidths(XMultiServiceFactory xMultiServiceFactory, XTextTable xTextTable) {
        try {
            XFrame xFrame = this.xTextDocument.getCurrentController().getFrame();
            int n = xTextTable.getColumns().getCount();
            XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)xTextTable);
            XCellRange xCellRange2 = xCellRange.getCellRangeByPosition(0, 0, n - 1, 1);
            short s = AnyConverter.toShort((Object)Helper.getUnoPropertyValue(xTextTable, "HoriOrient"));
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)this.xTextDocument.getCurrentController());
            xSelectionSupplier.select((Object)xCellRange2);
            Desktop.dispatchURL(xMultiServiceFactory, ".Uno:DistributeColumns", xFrame);
            Desktop.dispatchURL(xMultiServiceFactory, ".Uno:SetOptimalColumnWidth", xFrame);
            Helper.setUnoPropertyValue(xTextTable, "HoriOrient", s);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

