"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createAlertingCluster;
var _alertingPlugin = _interopRequireDefault(require("./alertingPlugin"));
var _constants = require("../../services/utils/constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createAlertingCluster(core, globalConfig, dataSourceEnabled, dataSource) {
  const {
    customHeaders,
    ...rest
  } = globalConfig.opensearch;
  if (dataSourceEnabled) {
    dataSource.registerCustomApiSchema(_alertingPlugin.default);
  }
  return core.opensearch.legacy.createClient(_constants.CLUSTER.ALERTING, {
    plugins: [_alertingPlugin.default],
    // Currently we are overriding any headers with our own since we explicitly required User-Agent to be OpenSearch Dashboards
    // for integration with our backend plugin.
    // TODO: Change our required header to x-<Header> to avoid overriding
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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