"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const Container = styled_components_1.default.div `
  margin-left: var(--prompt-width, 50px);
  padding: 5px;

  & label {
    padding-right: 5px;
  }
`;
class PromptRequest extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = { value: "" };
        this.handleChange = this.handleChange.bind(this);
        this.handleSubmitPromptReply = this.handleSubmitPromptReply.bind(this);
    }
    handleSubmitPromptReply(event) {
        event.preventDefault();
        this.props.submitPromptReply(this.state.value);
    }
    handleChange(event) {
        this.setState({ value: event.target.value });
    }
    render() {
        return (React.createElement(Container, null,
            React.createElement("form", { onSubmit: this.handleSubmitPromptReply },
                this.props.prompt && React.createElement("label", null, this.props.prompt),
                React.createElement("input", { type: this.props.password ? "password" : "text", value: this.state.value, onChange: this.handleChange }),
                React.createElement("input", { type: "submit" }))));
    }
}
exports.PromptRequest = PromptRequest;
exports.default = PromptRequest;
