"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SidebarItem = exports.getSidebarItemsFromData = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const icons_1 = require("../icons");
function getSidebarItemsFromData(data, isOpen, level = 0) {
    return data.map(({ name, subItems }) => (react_1.default.createElement(SidebarItem, { key: name, level: level, defaultIsExpanded: isOpen, className: classnames_1.default("sidebar-item", {
            "sidebar-item-file": !subItems,
        }), name: name, subItems: subItems })));
}
exports.getSidebarItemsFromData = getSidebarItemsFromData;
const openStates = {
    unset: undefined,
    open: true,
    closed: false,
};
class ListWrapper extends react_1.default.PureComponent {
    constructor() {
        super(...arguments);
        this.listEl = react_1.default.createRef();
    }
    componentDidMount() {
        const { level } = this.props;
        if (this.listEl && this.listEl.current) {
            this.listEl.current.style.setProperty("--padding", `${((level || 0) + 1) * 16}px`);
        }
    }
    render() {
        return (react_1.default.createElement("ul", Object.assign({ ref: this.listEl }, this.props), this.props.children));
    }
}
class SidebarItem extends react_1.default.PureComponent {
    constructor() {
        super(...arguments);
        this.state = { isExpanded: openStates.unset };
        this.handleToggleExpanded = (e) => {
            const { onSelect } = this.props;
            e.preventDefault();
            this.setState((previous) => ({ isExpanded: !previous.isExpanded }));
            if (onSelect) {
                onSelect();
            }
        };
    }
    render() {
        var _a, _b;
        const { subItems, name, defaultIsExpanded = false, level } = this.props;
        const isFolder = subItems !== undefined;
        const image = isFolder ? react_1.default.createElement(icons_1.Folder, null) : react_1.default.createElement(icons_1.File, null);
        const isOpen = (_a = this.state.isExpanded) !== null && _a !== void 0 ? _a : defaultIsExpanded;
        const folderImage = isFolder && (react_1.default.createElement(icons_1.Chevron, { className: classnames_1.default("chevron", { rotate: !isOpen }) }));
        return (react_1.default.createElement("li", Object.assign({}, this.props, { className: classnames_1.default("sidebar-item", {
                "sidebar-item-file": !subItems,
            }) }),
            react_1.default.createElement("button", { className: "sidebar-item-button", onClick: this.handleToggleExpanded },
                folderImage,
                image,
                " ",
                name),
            subItems && subItems.length > 0 && (react_1.default.createElement(ListWrapper, { level: level, className: classnames_1.default("sidebar-item-group", {
                    "sidebar-item-group-expanded": (_b = this.state.isExpanded) !== null && _b !== void 0 ? _b : defaultIsExpanded,
                }) }, getSidebarItemsFromData(subItems, false, level + 1)))));
    }
}
exports.SidebarItem = SidebarItem;
//# sourceMappingURL=sidebar-item.js.map