/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.plugin;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MappingTransformer;
import org.opensearch.ingest.Processor;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.neuralsearch.executors.HybridQueryExecutor;
import org.opensearch.neuralsearch.highlight.SemanticHighlighter;
import org.opensearch.neuralsearch.highlight.SemanticHighlighterEngine;
import org.opensearch.neuralsearch.highlight.extractor.QueryTextExtractorRegistry;
import org.opensearch.neuralsearch.mapper.SemanticFieldMapper;
import org.opensearch.neuralsearch.mappingtransformer.SemanticMappingTransformer;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.AgenticQueryTranslatorProcessor;
import org.opensearch.neuralsearch.processor.NeuralQueryEnricherProcessor;
import org.opensearch.neuralsearch.processor.NeuralSparseTwoPhaseProcessor;
import org.opensearch.neuralsearch.processor.NormalizationProcessorWorkflow;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationFactory;
import org.opensearch.neuralsearch.processor.combination.ScoreCombiner;
import org.opensearch.neuralsearch.processor.factory.ExplanationResponseProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.NormalizationProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.RRFProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.RerankProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.SemanticFieldProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.SparseEncodingProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.TextChunkingProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.TextEmbeddingProcessorFactory;
import org.opensearch.neuralsearch.processor.factory.TextImageEmbeddingProcessorFactory;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationFactory;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizer;
import org.opensearch.neuralsearch.query.AgenticSearchQueryBuilder;
import org.opensearch.neuralsearch.query.HybridQueryBuilder;
import org.opensearch.neuralsearch.query.NeuralKNNQueryBuilder;
import org.opensearch.neuralsearch.query.NeuralQueryBuilder;
import org.opensearch.neuralsearch.query.NeuralSparseQueryBuilder;
import org.opensearch.neuralsearch.query.ext.RerankSearchExtBuilder;
import org.opensearch.neuralsearch.rest.RestNeuralStatsAction;
import org.opensearch.neuralsearch.search.query.HybridQueryPhaseSearcher;
import org.opensearch.neuralsearch.settings.NeuralSearchSettings;
import org.opensearch.neuralsearch.settings.NeuralSearchSettingsAccessor;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;
import org.opensearch.neuralsearch.stats.info.InfoStatsManager;
import org.opensearch.neuralsearch.transport.NeuralStatsAction;
import org.opensearch.neuralsearch.transport.NeuralStatsTransportAction;
import org.opensearch.neuralsearch.util.NeuralSearchClusterUtil;
import org.opensearch.neuralsearch.util.PipelineServiceUtil;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.IngestPlugin;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPipelinePlugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.search.fetch.subphase.highlight.Highlighter;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchPhaseResultsProcessor;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.search.query.QueryPhaseSearcher;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;
import org.opensearch.watcher.ResourceWatcherService;

public class NeuralSearch
extends Plugin
implements ActionPlugin,
MapperPlugin,
SearchPlugin,
IngestPlugin,
ExtensiblePlugin,
SearchPipelinePlugin {
    @Generated
    private static final Logger log = LogManager.getLogger(NeuralSearch.class);
    private MLCommonsClientAccessor clientAccessor;
    private NamedXContentRegistry xContentRegistry;
    private NormalizationProcessorWorkflow normalizationProcessorWorkflow;
    private NeuralSearchSettingsAccessor settingsAccessor;
    private PipelineServiceUtil pipelineServiceUtil;
    private InfoStatsManager infoStatsManager;
    private final ScoreNormalizationFactory scoreNormalizationFactory = new ScoreNormalizationFactory();
    private final ScoreCombinationFactory scoreCombinationFactory = new ScoreCombinationFactory();
    private final SemanticHighlighter semanticHighlighter = new SemanticHighlighter();
    public static final String EXPLANATION_RESPONSE_KEY = "explanation_response";
    public static final String NEURAL_BASE_URI = "/_plugins/_neural";

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        NeuralSearchClusterUtil.instance().initialize(clusterService, indexNameExpressionResolver);
        NeuralQueryBuilder.initialize(this.clientAccessor);
        NeuralSparseQueryBuilder.initialize(this.clientAccessor);
        QueryTextExtractorRegistry queryTextExtractorRegistry = new QueryTextExtractorRegistry();
        SemanticHighlighterEngine semanticHighlighterEngine = SemanticHighlighterEngine.builder().mlCommonsClient(this.clientAccessor).queryTextExtractorRegistry(queryTextExtractorRegistry).build();
        this.semanticHighlighter.initialize(semanticHighlighterEngine);
        HybridQueryExecutor.initialize(threadPool);
        this.normalizationProcessorWorkflow = new NormalizationProcessorWorkflow(new ScoreNormalizer(), new ScoreCombiner());
        this.settingsAccessor = new NeuralSearchSettingsAccessor(clusterService, environment.settings());
        AgenticSearchQueryBuilder.initialize(this.settingsAccessor);
        this.pipelineServiceUtil = new PipelineServiceUtil(clusterService);
        this.infoStatsManager = new InfoStatsManager(NeuralSearchClusterUtil.instance(), this.settingsAccessor, this.pipelineServiceUtil);
        EventStatsManager.instance().initialize(this.settingsAccessor);
        this.xContentRegistry = xContentRegistry;
        return List.of(this.clientAccessor, EventStatsManager.instance(), this.infoStatsManager);
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Arrays.asList(new SearchPlugin.QuerySpec("neural", NeuralQueryBuilder::new, NeuralQueryBuilder::fromXContent), new SearchPlugin.QuerySpec("hybrid", HybridQueryBuilder::new, HybridQueryBuilder::fromXContent), new SearchPlugin.QuerySpec("neural_sparse", NeuralSparseQueryBuilder::new, NeuralSparseQueryBuilder::fromXContent), new SearchPlugin.QuerySpec("neural_knn", NeuralKNNQueryBuilder::new, NeuralKNNQueryBuilder::fromXContent), new SearchPlugin.QuerySpec("agentic", AgenticSearchQueryBuilder::new, AgenticSearchQueryBuilder::fromXContent));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestNeuralStatsAction restNeuralStatsAction = new RestNeuralStatsAction(this.settingsAccessor, NeuralSearchClusterUtil.instance());
        return ImmutableList.of((Object)((Object)restNeuralStatsAction));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)NeuralStatsAction.INSTANCE, NeuralStatsTransportAction.class, new Class[0]));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return List.of(HybridQueryExecutor.getExecutorBuilder(settings));
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        this.clientAccessor = new MLCommonsClientAccessor(new MachineLearningNodeClient(parameters.client));
        return Map.of("text_embedding", new TextEmbeddingProcessorFactory((OpenSearchClient)parameters.client, this.clientAccessor, parameters.env, parameters.ingestService.getClusterService()), "sparse_encoding", new SparseEncodingProcessorFactory((OpenSearchClient)parameters.client, this.clientAccessor, parameters.env, parameters.ingestService.getClusterService()), "text_image_embedding", new TextImageEmbeddingProcessorFactory((OpenSearchClient)parameters.client, this.clientAccessor, parameters.env, parameters.ingestService.getClusterService()), "text_chunking", new TextChunkingProcessorFactory(parameters.env, parameters.ingestService.getClusterService(), parameters.analysisRegistry));
    }

    public Optional<QueryPhaseSearcher> getQueryPhaseSearcher() {
        return Optional.of(new HybridQueryPhaseSearcher());
    }

    public Map<String, Processor.Factory<SearchPhaseResultsProcessor>> getSearchPhaseResultsProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of("normalization-processor", new NormalizationProcessorFactory(this.normalizationProcessorWorkflow, this.scoreNormalizationFactory, this.scoreCombinationFactory), "score-ranker-processor", new RRFProcessorFactory(this.normalizationProcessorWorkflow, this.scoreNormalizationFactory, this.scoreCombinationFactory));
    }

    public List<Setting<?>> getSettings() {
        return List.of(NeuralSearchSettings.RERANKER_MAX_DOC_FIELDS, NeuralSearchSettings.NEURAL_STATS_ENABLED, NeuralSearchSettings.SEMANTIC_INGEST_BATCH_SIZE, NeuralSearchSettings.HYBRID_COLLAPSE_DOCS_PER_GROUP_PER_SUBQUERY, NeuralSearchSettings.AGENTIC_SEARCH_ENABLED);
    }

    public Map<String, Processor.Factory<SearchRequestProcessor>> getRequestProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of("neural_query_enricher", new NeuralQueryEnricherProcessor.Factory(), "neural_sparse_two_phase_processor", new NeuralSparseTwoPhaseProcessor.Factory(), "agentic_query_translator", new AgenticQueryTranslatorProcessor.Factory(this.clientAccessor, this.xContentRegistry, this.settingsAccessor));
    }

    public Map<String, Processor.Factory<SearchResponseProcessor>> getResponseProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of("rerank", new RerankProcessorFactory(this.clientAccessor, parameters.searchPipelineService.getClusterService()), "hybrid_score_explanation", new ExplanationResponseProcessorFactory());
    }

    public List<SearchPlugin.SearchExtSpec<?>> getSearchExts() {
        return List.of(new SearchPlugin.SearchExtSpec("rerank", in -> new RerankSearchExtBuilder(in), parser -> RerankSearchExtBuilder.parse(parser)));
    }

    public Map<String, Highlighter> getHighlighters() {
        return Collections.singletonMap("semantic", this.semanticHighlighter);
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Map.of("semantic", new SemanticFieldMapper.TypeParser());
    }

    public List<MappingTransformer> getMappingTransformers() {
        return List.of(new SemanticMappingTransformer(this.clientAccessor, this.xContentRegistry));
    }

    public Map<String, Processor.Factory> getSystemIngestProcessors(Processor.Parameters parameters) {
        return Map.of("system_ingest_processor_factory_semantic_field", new SemanticFieldProcessorFactory(this.clientAccessor, parameters.env, parameters.ingestService.getClusterService(), parameters.analysisRegistry, (OpenSearchClient)parameters.client));
    }
}

