\name{AdaptiveHistogramEqualizationImageFilter}
\alias{AdaptiveHistogramEqualizationImageFilter}
\title{AdaptiveHistogramEqualizationImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Power Law Adaptive Histogram Equalization.
AdaptiveHistogramEqualizationImageFilter}
\details{
Histogram equalization modifies the contrast in an image. The AdaptiveHistogramEqualizationImageFilter is a superset of many contrast enhancing filters. By modifying its
parameters (alpha, beta, and window), the AdaptiveHistogramEqualizationImageFilter can produce an adaptively equalized histogram or a version of unsharp
mask (local mean subtraction). Instead of applying a strict histogram
equalization in a window about a pixel, this filter prescribes a
mapping function (power law) controlled by the parameters alpha and
beta.
The parameter alpha controls how much the filter acts like the
classical histogram equalization method (alpha=0) to how much the
filter acts like an unsharp mask (alpha=1).
The parameter beta controls how much the filter acts like an unsharp
mask (beta=0) to much the filter acts like pass through (beta=1, with
alpha=1).
The parameter window controls the size of the region over which local
statistics are calculated. The size of the window is controlled by
SetRadius the default Radius is 5 in all directions.
By altering alpha, beta and window, a host of equalization and unsharp
masking filters is available.
The boundary condition ignores the part of the neighborhood outside
the image, and over-weights the valid part of the neighborhood.
For detail description, reference "Adaptive Image Contrast
Enhancement using Generalizations of Histogram Equalization." J.Alex
Stark. IEEE Transactions on Image Processing, May 2000.
See:
AdaptiveHistogramEqualization for the procedural interface
itk::AdaptiveHistogramEqualizationImageFilter for the Doxygen on the original ITK class.
AdaptiveHistogramEqualizationImageFilter}
%C++ includes: sitkAdaptiveHistogramEqualizationImageFilter.h
\section{Methods}{
\describe{
\item{ AdaptiveHistogramEqualizationImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{float GetAlpha() const:}{
Set/Get the value of alpha. Alpha = 0 produces the adaptive histogram
equalization (provided beta=0). Alpha = 1 produces an unsharp mask.
Default is 0.3.
}
\item{float GetBeta() const:}{
Set/Get the value of beta. If beta = 1 (and alpha = 1), then the
output image matches the input image. As beta approaches 0, the filter
behaves as an unsharp mask. Default is 0.3.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetRadius() const:}{}
\item{Self SetAlpha(float Alpha):}{
Set/Get the value of alpha. Alpha = 0 produces the adaptive histogram
equalization (provided beta=0). Alpha = 1 produces an unsharp mask.
Default is 0.3.
}
\item{Self SetBeta(float Beta):}{
Set/Get the value of beta. If beta = 1 (and alpha = 1), then the
output image matches the input image. As beta approaches 0, the filter
behaves as an unsharp mask. Default is 0.3.
}
\item{Self SetRadius(std::vector< unsigned int > Radius):}{}
\item{Self SetRadius(unsigned int value):}{
Set the values of the Radius vector all to value
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~AdaptiveHistogramEqualizationImageFilter():}{
Destructor
}
}
}
