\name{BinaryNotImageFilter}
\alias{BinaryNotImageFilter}
\title{BinaryNotImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements the BinaryNot logical operator pixel-wise between two
images.
BinaryNotImageFilter}
\details{
This class is parameterized over the types of the two input images and
the type of the output image. Numeric conversions (castings) are done
by the C++ defaults.
The total operation over one pixel will be
output_pixel = static_cast<PixelType>( input1_pixel != input2_pixel )
Where "!=" is the equality operator in C++.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
See:
BinaryNot for the procedural interface
itk::BinaryNotImageFilter for the Doxygen on the original ITK class.
BinaryNotImageFilter}
%C++ includes: sitkBinaryNotImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryNotImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Set/Get the value used as "background". Defaults to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{double GetForegroundValue() const:}{
Set/Get the value in the image considered as "foreground". Defaults
to maximum value of PixelType.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the value used as "background". Defaults to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set/Get the value in the image considered as "foreground". Defaults
to maximum value of PixelType.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryNotImageFilter():}{
Destructor
}
}
}
