\name{BinaryThresholdImageFilter}
\alias{BinaryThresholdImageFilter}
\title{BinaryThresholdImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Binarize an input image by thresholding.
BinaryThresholdImageFilter}
\details{
This filter produces an output image whose pixels are either one of
two values ( OutsideValue or InsideValue ), depending on whether the
corresponding input image pixels lie between the two thresholds (
LowerThreshold and UpperThreshold ). Values equal to either threshold
is considered to be between the thresholds.
More precisely \deqn{ Output(x_i) = \begin{cases} InsideValue if LowerThreshold \leq x_i \leq UpperThreshold \\ OutsideValue otherwise \end{cases} }
This filter is templated over the input image type and the output
image type.
The filter expect both images to have the same number of dimensions.
The default values for LowerThreshold and UpperThreshold are:
LowerThreshold = NumericTraits<TInput>::NonpositiveMin() ; UpperThreshold = NumericTraits<TInput>::max() ; Therefore, generally only one of these needs to be set, depending
on whether the user wants to threshold above or below the desired
threshold.
See:
BinaryThreshold for the procedural interface
itk::BinaryThresholdImageFilter for the Doxygen on the original ITK class.
BinaryThresholdImageFilter}
%C++ includes: sitkBinaryThresholdImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryThresholdImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{uint8_t GetInsideValue() const:}{
Get the "inside" pixel value.
}
\item{double GetLowerThreshold() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint8_t GetOutsideValue() const:}{
Get the "outside" pixel value.
}
\item{double GetUpperThreshold() const:}{
Get the threshold values.
}
\item{Self SetInsideValue(uint8_t InsideValue):}{
Set the "inside" pixel value. The default value NumericTraits<OutputPixelType>::max()
}
\item{Self SetLowerThreshold(double LowerThreshold):}{}
\item{Self SetOutsideValue(uint8_t OutsideValue):}{
Set the "outside" pixel value. The default value NumericTraits<OutputPixelType>::ZeroValue() .
}
\item{Self SetUpperThreshold(double UpperThreshold):}{
Set the thresholds. The default lower threshold is NumericTraits<InputPixelType>::NonpositiveMin() . The default upper threshold is NumericTraits<InputPixelType>::max . An exception is thrown if the lower threshold is greater than the
upper threshold.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryThresholdImageFilter():}{
Destructor
}
}
}
