\name{CannySegmentationLevelSetImageFilter}
\alias{CannySegmentationLevelSetImageFilter}
\title{CannySegmentationLevelSetImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Segments structures in images based on image features derived from
pseudo-canny-edges.
CannySegmentationLevelSetImageFilter}
\details{
IMPORTANT
The SegmentationLevelSetImageFilter class and the CannySegmentationLevelSetFunction class contain additional information necessary to the full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. It constructs a
speed function which is designed to lock onto edges as detected by a
Canny filter.
The CannySegmentationLevelSetImageFilter can be a tool for refining an existing segmentation, or it can be
used to try to segment a region by itself. Like all other level-set
based segmentation filters (see SegmentationLevelSetImageFilter ), it works by first constructing a scalar speed term and a vector
advection field based on edge features in the image. The level set
front is then moved according to these two terms with the addition of
a third curvature term to control the smoothness of the solution.
The speed term is constructed as the Danielsson distance transform of
the Canny edge image, as calculated by the CannyEdgeDetectionImageFilter . This scalar speed can be tuned in and out of the final evolution
equation by setting the PropagationScaling parameter (a value of 0
removes the speed term).
The advection field term is constructed by minimizing Danielsson
distance squared. i.e. \eqn{ min \int D^2 \Rightarrow D \nabla D } . This term moves the level set down the gradient of the distance
transform.
In practice, you may set the speed (propagation) term to zero if your
initialization is already close to the edge you are interested in. If
you are trying to segment a region by seeding with a small surface
(blob, sphere) then you will likely want to add speed (propagation) to
the equation so that the levelsets can expand along zero gradients.
The relative influence of these two terms are controlled by the
SetPropagationScaling and SetAdvectionScaling parameters.
INPUTS
This filter requires two inputs. The first input is a seed image. This
seed image must contain an isosurface that you want to use as the seed
for your segmentation. It can be a binary, graylevel, or floating
point image. The only requirement is that it contain a closed
isosurface that you will identify as the seed by setting the
IsosurfaceValue parameter of the filter. For a binary image you will
want to set your isosurface value halfway between your on and off
values (i.e. for 0's and 1's, use an isosurface value of 0.5).
The second input is the feature image. This is the image from which
the speed function will be calculated. For most applications, this is
the image that you want to segment. The desired isosurface in your
seed image should lie within the region of your feature image that you
are trying to segment.
See SegmentationLevelSetImageFilter for more information on Inputs.
OUTPUTS
The filter outputs a single, scalar, real-valued image. Positive
*values in the output image are inside the segmented region and
negative *values in the image are outside of the inside region. The
zero crossings of *the image correspond to the position of the level
set front.
See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
PARAMETERS
There are five parameters important for controlling the behavior of
this filter.
(1) Threshold. Sets the thresholding value of the Canny edge
detection. See CannyEdgeDetectionImageFilter for more information.
(2) Variance. Controls the smoothing parameter of the gaussian
filtering done during Canny edge detection.
(3) CurvatureScaling. Controls the degree to which curvature
influences the evolution of the level set. Higher values relative to
Propagation and Advection scalings will yield a smoother surface.
(4) PropagationScaling. Scales the propagation (speed) term of the
level set equation. Set this term to zero to allow the level set to
flow only down the gradient of the distance transform.
(5) AdvectionScaling. Scales influence of the advection field relative
to curvature and propagation terms.
See:
SegmentationLevelSetImageFilter
CannySegmentationLevelSetFunction ,
SparseFieldLevelSetImageFilter
CannySegmentationLevelSet for the procedural interface
itk::CannySegmentationLevelSetImageFilter for the Doxygen on the original ITK class.
CannySegmentationLevelSetImageFilter}
%C++ includes: sitkCannySegmentationLevelSetImageFilter.h
\section{Methods}{
\describe{
\item{ CannySegmentationLevelSetImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &initialImage, const Image &featureImage):}{}
\item{Image Execute(Image &&initialImage, const Image &featureImage):}{
Execute the filter on the input image
}
\item{double GetAdvectionScaling() const:}{}
\item{Image GetCannyImage() const:}{
Get the Canny image that was used to create the speed and advection
images
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetCurvatureScaling() const:}{}
\item{uint32_t GetElapsedIterations() const:}{
Number of iterations run.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetIsoSurfaceValue() const:}{}
\item{double GetMaximumRMSError() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetPropagationScaling() const:}{}
\item{bool GetReverseExpansionDirection() const:}{}
\item{double GetRMSChange() const:}{
The Root Mean Square of the levelset upon termination.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetThreshold() const:}{
Set the Threshold parameter of the CannyEdgeDetectionImageFilter used by the underlying level set function.
}
\item{double GetVariance() const:}{
Set the Variance parameter of the CannyEdgeDetectionImageFilter used by the underlying level set function.
}
\item{Self ReverseExpansionDirectionOff():}{}
\item{Self ReverseExpansionDirectionOn():}{
Set the value of ReverseExpansionDirection to true or false
respectfully.
}
\item{Self SetAdvectionScaling(double AdvectionScaling):}{}
\item{Self SetCurvatureScaling(double CurvatureScaling):}{}
\item{Self SetIsoSurfaceValue(double IsoSurfaceValue):}{}
\item{Self SetMaximumRMSError(double MaximumRMSError):}{}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetPropagationScaling(double PropagationScaling):}{}
\item{Self SetReverseExpansionDirection(bool ReverseExpansionDirection):}{}
\item{Self SetThreshold(double Threshold):}{
Set the Threshold parameter of the CannyEdgeDetectionImageFilter used by the underlying level set function.
}
\item{Self SetVariance(double Variance):}{
Set the Variance parameter of the CannyEdgeDetectionImageFilter used by the underlying level set function.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~CannySegmentationLevelSetImageFilter():}{
Destructor
}
}
}
