\name{CheckerBoardImageFilter}
\alias{CheckerBoardImageFilter}
\title{CheckerBoardImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Combines two images in a checkerboard pattern.
CheckerBoardImageFilter}
\details{
CheckerBoardImageFilter takes two input images that must have the same dimension, size,
origin and spacing and produces an output image of the same size by
combining the pixels from the two input images in a checkerboard
pattern. This filter is commonly used for visually comparing two
images, in particular for evaluating the results of an image
registration process.
This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.
See:
CheckerBoard for the procedural interface
itk::CheckerBoardImageFilter for the Doxygen on the original ITK class.
CheckerBoardImageFilter}
%C++ includes: sitkCheckerBoardImageFilter.h
\section{Methods}{
\describe{
\item{ CheckerBoardImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{std::vector< uint32_t > GetCheckerPattern() const:}{
Set/Get the checker pattern array, i.e. the number of checker boxes
per image dimension.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetCheckerPattern(std::vector< uint32_t > CheckerPattern):}{
Set/Get the checker pattern array, i.e. the number of checker boxes
per image dimension.
}
\item{Self SetCheckerPattern(uint32_t value):}{
Set the values of the CheckerPattern vector all to value
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~CheckerBoardImageFilter():}{
Destructor
}
}
}
