\name{CyclicShiftImageFilter}
\alias{CyclicShiftImageFilter}
\title{CyclicShiftImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Perform a cyclic spatial shift of image intensities on the image grid.
CyclicShiftImageFilter}
\details{
This filter supports arbitrary cyclic shifts of pixel values on the
image grid. If the Shift is set to [xOff, yOff], the value of the
pixel at [0, 0] in the input image will be the value of the pixel in
the output image at index [xOff modulo xSize, yOff modulo ySize] where
xSize and ySize are the sizes of the image in the x and y dimensions,
respectively. If a pixel value is moved across a boundary, the pixel
value is wrapped around that boundary. For example, if the image is
40-by-40 and the Shift is [13, 47], then the value of the pixel at [0,
0] in the input image will be the value of the pixel in the output
image at index [13, 7].
Negative Shifts are supported. This filter also works with images
whose largest possible region starts at a non-zero index.
See:
CyclicShift for the procedural interface
itk::CyclicShiftImageFilter for the Doxygen on the original ITK class.
CyclicShiftImageFilter}
%C++ includes: sitkCyclicShiftImageFilter.h
\section{Methods}{
\describe{
\item{ CyclicShiftImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< int > GetShift() const:}{
Set/get the shift. Shifts may be positive or negative.
}
\item{Self SetShift(int value):}{
Set the values of the Shift vector all to value
}
\item{Self SetShift(std::vector< int > Shift):}{
Set/get the shift. Shifts may be positive or negative.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~CyclicShiftImageFilter():}{
Destructor
}
}
}
