\name{HalfHermitianToRealInverseFFTImageFilter}
\alias{HalfHermitianToRealInverseFFTImageFilter}
\title{HalfHermitianToRealInverseFFTImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Base class for specialized complex-to-real inverse Fast Fourier Transform .
HalfHermitianToRealInverseFFTImageFilter}
\details{
This is a base class for the "inverse" or "reverse" Discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child class available on the system when the
object is created via the object factory system.
The input to this filter is assumed to have the same format as the
output of the RealToHalfHermitianForwardFFTImageFilter . That is, the input is assumed to consist of roughly half the full
complex image resulting from a real-to-complex discrete Fourier
transform. This half is expected to be the first half of the image in
the X-dimension. Because this filter assumes that the input stores
only about half of the non-redundant complex pixels, the output is
larger in the X-dimension than it is in the input. To determine the
actual size of the output image, this filter needs additional
information in the form of a flag indicating whether the output image
has an odd size in the X-dimension. Use SetActualXDimensionIsOdd() to set this flag.
See:
ForwardFFTImageFilter , HalfHermitianToRealInverseFFTImageFilter
HalfHermitianToRealInverseFFT for the procedural interface
itk::HalfHermitianToRealInverseFFTImageFilter for the Doxygen on the original ITK class.
HalfHermitianToRealInverseFFTImageFilter}
%C++ includes: sitkHalfHermitianToRealInverseFFTImageFilter.h
\section{Methods}{
\describe{
\item{Self ActualXDimensionIsOddOff():}{}
\item{Self ActualXDimensionIsOddOn():}{
Set the value of ActualXDimensionIsOdd to true or false respectfully.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{bool GetActualXDimensionIsOdd() const:}{
Was the original truncated dimension size odd?
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ HalfHermitianToRealInverseFFTImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetActualXDimensionIsOdd(bool ActualXDimensionIsOdd):}{
Was the original truncated dimension size odd?
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~HalfHermitianToRealInverseFFTImageFilter():}{
Destructor
}
}
}
