\name{NaryMaximumImageFilter}
\alias{NaryMaximumImageFilter}
\title{NaryMaximumImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the pixel-wise maximum of several images.
NaryMaximumImageFilter}
\details{
This class is templated over the types of the input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.
The pixel type of the output images must have a valid definition of
the operator<. This condition is required because internally this
filter will perform an operation similar to:
 (where current_maximum is also of type OutputPixelType)
for each of the n input images.
For example, this filter could be used directly to find a "maximum
projection" of a series of images, often used in preliminary analysis
of time-series data.
Zachary Pincus
 This filter was contributed by Zachary Pincus from the Department of
Biochemistry and Program in Biomedical Informatics at Stanford
University School of Medicine
See:
NaryMaximum for the procedural interface
NaryMaximumImageFilter}
%C++ includes: sitkNaryMaximumImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4, const Image &image5):}{}
\item{Image Execute(const std::vector< Image > &images):}{
Execute the filter on the input images
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ NaryMaximumImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~NaryMaximumImageFilter():}{
Destructor
}
}
}
