\name{ReconstructionByErosionImageFilter}
\alias{ReconstructionByErosionImageFilter}
\title{ReconstructionByErosionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
grayscale reconstruction by erosion of an image
ReconstructionByErosionImageFilter}
\details{
Reconstruction by erosion operates on a "marker" image and a
"mask" image, and is defined as the erosion of the marker image with
respect to the mask image iterated until stability.
The marker image must be less than or equal to the mask image (on a
pixel by pixel basis).
Geodesic morphology is described in Chapter 6.2 of Pierre Soille's
book "Morphological Image Analysis: Principles and Applications",
Second Edition, Springer, 2003.
Algorithm implemented in this filter is based on algorithm described by Kevin
Robinson and Paul F. Whelan in "Efficient Morphological
Reconstruction: A Downhill Filter", Pattern Recognition Letters,
Volume 25, Issue 15, November 2004, Pages 1759-1767.
The algorithm, a description of the transform and some applications
can be found in "Morphological Grayscale Reconstruction in Image
Analysis:  Applications and Efficient Algorithms", Luc Vincent, IEEE
Transactions on image processing, Vol. 2, April 1993.
Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
See:
MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter , ReconstructionByErosionImageFilter , OpeningByReconstructionImageFilter , ClosingByReconstructionImageFilter , ReconstructionImageFilter
ReconstructionByErosion for the procedural interface
itk::ReconstructionByErosionImageFilter for the Doxygen on the original ITK class.
ReconstructionByErosionImageFilter}
%C++ includes: sitkReconstructionByErosionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &markerImage, const Image &maskImage):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetUseInternalCopy() const:}{}
\item{ ReconstructionByErosionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetFullyConnected(bool FullyConnected):}{}
\item{Self SetUseInternalCopy(bool UseInternalCopy):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseInternalCopyOff():}{}
\item{Self UseInternalCopyOn():}{
Set the value of UseInternalCopy to true or false respectfully.
}
\item{ ~ReconstructionByErosionImageFilter():}{
Destructor
}
}
}
