\name{RelabelComponentImageFilter}
\alias{RelabelComponentImageFilter}
\title{RelabelComponentImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Relabel the components in an image such that consecutive labels are
used.
RelabelComponentImageFilter}
\details{
RelabelComponentImageFilter remaps the labels associated with the objects in an image (as from
the output of ConnectedComponentImageFilter ) such that the label numbers are consecutive with no gaps between
the label numbers used. By default, the relabeling will also sort the
labels based on the size of the object: the largest object will have
label #1, the second largest will have label #2, etc. If two labels
have the same size their initial order is kept. The sorting by size
can be disabled using SetSortByObjectSize.
Label #0 is assumed to be the background and is left unaltered by the
relabeling.
RelabelComponentImageFilter is typically used on the output of the ConnectedComponentImageFilter for those applications that want to extract the largest object or the
"k" largest objects. Any particular object can be extracted from the
relabeled output using a BinaryThresholdImageFilter . A group of objects can be extracted from the relabeled output using
a ThresholdImageFilter .
Once all the objects are relabeled, the application can query the
number of objects and the size of each object. Object sizes are returned in a vector. The size of the background is not
calculated. So the size of object #1 is GetSizeOfObjectsInPixels() [0], the size of object #2 is GetSizeOfObjectsInPixels() [1], etc.
If user sets a minimum object size, all objects with fewer pixels than
the minimum will be discarded, so that the number of objects reported
will be only those remaining. The GetOriginalNumberOfObjects method
can be called to find out how many objects were present before the
small ones were discarded.
RelabelComponentImageFilter can be run as an "in place" filter, where it will overwrite its
output. The default is run out of place (or generate a separate
output). "In place" operation can be controlled via methods in the
superclass, InPlaceImageFilter::InPlaceOn() and InPlaceImageFilter::InPlaceOff().
See:
ConnectedComponentImageFilter , BinaryThresholdImageFilter , ThresholdImageFilter
RelabelComponent for the procedural interface
itk::RelabelComponentImageFilter for the Doxygen on the original ITK class.
RelabelComponentImageFilter}
%C++ includes: sitkRelabelComponentImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{uint64_t GetMinimumObjectSize() const:}{
Get the caller-defined minimum size of an object in pixels. If the
caller has not set the minimum, 0 will be returned, which is to be
interpreted as meaning that no minimum exists, and all objects in the
original label map will be passed through to the output.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfObjects() const:}{
Get the number of objects in the image. This information is only valid
after the filter has executed.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{uint32_t GetOriginalNumberOfObjects() const:}{
Get the original number of objects in the image before small objects
were discarded. This information is only valid after the filter has
executed. If the caller has not specified a minimum object size,
OriginalNumberOfObjects is the same as NumberOfObjects.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{std::vector< float > GetSizeOfObjectsInPhysicalUnits() const:}{
Get the size of each object in physical space (in units of pixel
size). This information is only valid after the filter has executed. Size of the background is not calculated. Size of object #1 is GetSizeOfObjectsInPhysicalUnits() [0]. Size of object #2 is GetSizeOfObjectsInPhysicalUnits() [1]. Etc.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{std::vector< uint64_t > GetSizeOfObjectsInPixels() const:}{
Get the size of each object in pixels. This information is only valid
after the filter has executed. Size of the background is not calculated. Size of object #1 is GetSizeOfObjectsInPixels() [0]. Size of object #2 is GetSizeOfObjectsInPixels() [1]. Etc.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{bool GetSortByObjectSize() const:}{
Controls whether the object labels are sorted by size. If false,
initial order of labels is kept.
}
\item{ RelabelComponentImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetMinimumObjectSize(uint64_t MinimumObjectSize):}{
Set the minimum size in pixels for an object. All objects smaller than
this size will be discarded and will not appear in the output label
map. NumberOfObjects will count only the objects whose pixel counts
are greater than or equal to the minimum size. Call
GetOriginalNumberOfObjects to find out how many objects were present
in the original label map.
}
\item{Self SetSortByObjectSize(bool SortByObjectSize):}{
Controls whether the object labels are sorted by size. If false,
initial order of labels is kept.
}
\item{Self SortByObjectSizeOff():}{}
\item{Self SortByObjectSizeOn():}{
Set the value of SortByObjectSize to true or false respectfully.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~RelabelComponentImageFilter():}{
Destructor
}
}
}
