\name{SimilarityIndexImageFilter}
\alias{SimilarityIndexImageFilter}
\title{SimilarityIndexImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Measures the similarity between the set of non-zero pixels of two
images.
SimilarityIndexImageFilter}
\details{
SimilarityIndexImageFilter measures the similarity between the set non-zero pixels of two images
using the following formula: \deqn{ S = \frac{2 | A \cap B |}{|A| + |B|} } where \eqn{A} and \eqn{B} are respectively the set of non-zero pixels in the first and second
input images. Operator \eqn{|\cdot|} represents the size of a set and \eqn{\cap} represents the intersection of two sets.
The measure is derived from a reliability measure known as the kappa
statistic. \eqn{S} is sensitive to both differences in size and in location and have
been in the literature for comparing two segmentation masks. For more
information see: "Morphometric Analysis of White Matter Lesions in MR
Images: Method and Validation", A. P. Zijdenbos, B. M. Dawant, R. A.
Margolin and A. C. Palmer, IEEE Trans. on Medical Imaging, 13(4) pp
716-724,1994
This filter requires the largest possible region of the first image
and the same corresponding region in the second image. It behaves as
filter with two input and one output. Thus it can be inserted in a
pipeline with other filters. The filter passes the first input through
unmodified.
This filter is templated over the two input image type. It assume both
image have the same number of dimensions.
See:
itk::SimilarityIndexImageFilter for the Doxygen on the original ITK class.
SimilarityIndexImageFilter}
%C++ includes: sitkSimilarityIndexImageFilter.h
\section{Methods}{
\describe{
\item{void Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetSimilarityIndex() const:}{
Return the computed similarity index.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{ SimilarityIndexImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~SimilarityIndexImageFilter():}{
Destructor
}
}
}
