\name{VotingBinaryImageFilter}
\alias{VotingBinaryImageFilter}
\title{VotingBinaryImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Applies a voting operation in a neighborhood of each pixel.
VotingBinaryImageFilter}
\details{
Pixels which are not Foreground or Background will remain unchanged.
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
VotingBinary for the procedural interface
itk::VotingBinaryImageFilter for the Doxygen on the original ITK class.
VotingBinaryImageFilter}
%C++ includes: sitkVotingBinaryImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Get the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{unsigned int GetBirthThreshold() const:}{
Birth threshold. Pixels that are OFF will turn ON when the number of
neighbors ON is larger than the value defined in this threshold.
}
\item{double GetForegroundValue() const:}{
Get the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetRadius() const:}{
Get the radius of the neighborhood used to compute the median
}
\item{unsigned int GetSurvivalThreshold() const:}{
Survival threshold. Pixels that are ON will turn OFF when the number
of neighbors ON is smaller than the value defined in this survival
threshold.
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{Self SetBirthThreshold(unsigned int BirthThreshold):}{
Birth threshold. Pixels that are OFF will turn ON when the number of
neighbors ON is larger than the value defined in this threshold.
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{Self SetRadius(std::vector< unsigned int > Radius):}{
Set the radius of the neighborhood used to compute the median.
}
\item{Self SetRadius(unsigned int value):}{
Set the values of the Radius vector all to value
}
\item{Self SetSurvivalThreshold(unsigned int SurvivalThreshold):}{
Survival threshold. Pixels that are ON will turn OFF when the number
of neighbors ON is smaller than the value defined in this survival
threshold.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ VotingBinaryImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~VotingBinaryImageFilter():}{
Destructor
}
}
}
