/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.gnome;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.proxy.NetworkProxySettings;
import org.netbeans.core.network.proxy.gnome.GnomeNetworkProxy;

public class GsettingsNetworkProxy {
    private static final Logger LOGGER = Logger.getLogger(GsettingsNetworkProxy.class.getName());
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String DOT = ".";
    private static final String COLON = ",";
    private static final String SINGLE_QUOTE = "'";
    private static final String SQ_BRACKET_LEFT = "[";
    private static final String SQ_BRACKET_RIGHT = "]";
    protected static final String GSETTINGS_PATH = "/usr/bin/gsettings";
    private static final String GSETTINGS_ARGUMENT_LIST_RECURSIVELY = " list-recursively ";
    private static final String GSETTINGS_PROXY_SCHEMA = "org.gnome.system.proxy";
    private static final String GSETTINGS_KEY_MODE = "org.gnome.system.proxy.mode";
    private static final String GSETTINGS_KEY_PAC_URL = "org.gnome.system.proxy.autoconfig-url";
    private static final String GSETTINGS_KEY_HTTP_ALL = "org.gnome.system.proxy.http.use-same-proxy";
    private static final String GSETTINGS_KEY_HTTP_HOST = "org.gnome.system.proxy.http.host";
    private static final String GSETTINGS_KEY_HTTP_PORT = "org.gnome.system.proxy.http.port";
    private static final String GSETTINGS_KEY_HTTPS_HOST = "org.gnome.system.proxy.https.host";
    private static final String GSETTINGS_KEY_HTTPS_PORT = "org.gnome.system.proxy.https.port";
    private static final String GSETTINGS_KEY_SOCKS_HOST = "org.gnome.system.proxy.socks.host";
    private static final String GSETTINGS_KEY_SOCKS_PORT = "org.gnome.system.proxy.socks.port";
    private static final String GSETTINGS_KEY_IGNORE_HOSTS = "org.gnome.system.proxy.ignore-hosts";
    private static final String GSETTINGS_VALUE_NONE = "none";
    private static final String GSETTINGS_VALUE_AUTO = "auto";
    private static final String GSETTINGS_VALUE_MANUAL = "manual";

    protected static NetworkProxySettings getNetworkProxySettings() {
        LOGGER.log(Level.FINE, "GSettings system proxy resolver started.");
        Map<String, String> map = GsettingsNetworkProxy.getGsettingsMap();
        String string = map.get(GSETTINGS_KEY_MODE);
        if (string == null) {
            LOGGER.log(Level.SEVERE, "GSettings proxy mode is null.");
            return new NetworkProxySettings(false);
        }
        if (string.equals(GSETTINGS_VALUE_NONE)) {
            LOGGER.log(Level.INFO, "GSettings system proxy resolver: direct connection");
            return new NetworkProxySettings();
        }
        if (string.equals(GSETTINGS_VALUE_AUTO)) {
            String string2 = map.get(GSETTINGS_KEY_PAC_URL);
            LOGGER.log(Level.INFO, "GSettings system proxy resolver: auto - PAC ({0})", string2);
            if (string2 != null) {
                return new NetworkProxySettings(string2);
            }
            return new NetworkProxySettings(EMPTY_STRING);
        }
        if (string.equals(GSETTINGS_VALUE_MANUAL)) {
            String string3 = map.get(GSETTINGS_KEY_HTTP_ALL);
            String string4 = map.get(GSETTINGS_KEY_HTTP_HOST);
            String string5 = map.get(GSETTINGS_KEY_HTTP_PORT);
            String string6 = map.get(GSETTINGS_KEY_IGNORE_HOSTS);
            LOGGER.log(Level.INFO, "GSettings system proxy resolver: manual - http for all ({0})", string3);
            LOGGER.log(Level.INFO, "GSettings system proxy resolver: manual - http host ({0})", string4);
            LOGGER.log(Level.INFO, "GSettings system proxy resolver: manual - http port ({0})", string5);
            LOGGER.log(Level.INFO, "GSettings system proxy resolver: manual - ho proxy hosts ({0})", string6);
            if (string3 != null && Boolean.parseBoolean(string3)) {
                return new NetworkProxySettings(string4, string5, GsettingsNetworkProxy.getNoProxyHosts(string6));
            }
            String string7 = map.get(GSETTINGS_KEY_HTTPS_HOST);
            String string8 = map.get(GSETTINGS_KEY_HTTPS_PORT);
            String string9 = map.get(GSETTINGS_KEY_SOCKS_HOST);
            String string10 = map.get(GSETTINGS_KEY_SOCKS_PORT);
            LOGGER.log(Level.INFO, "GSettings system proxy resolver: manual - https host ({0})", string7);
            LOGGER.log(Level.INFO, "GSettings system proxy resolver: manual - https port ({0})", string8);
            LOGGER.log(Level.INFO, "GSettings system proxy resolver: manual - socks host ({0})", string9);
            LOGGER.log(Level.INFO, "GSettings system proxy resolver: manual - socks port ({0})", string10);
            return new NetworkProxySettings(string4, string5, string7, string8, string9, string10, GsettingsNetworkProxy.getNoProxyHosts(string6));
        }
        return new NetworkProxySettings(false);
    }

    protected static boolean isGsettingsValid() {
        String string = "/usr/bin/gsettings list-recursively org.gnome.system.proxy";
        try {
            BufferedReader bufferedReader = GnomeNetworkProxy.executeCommand(string);
            if (bufferedReader.ready()) {
                return true;
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Cannot read line: " + string, iOException);
        }
        LOGGER.log(Level.INFO, "GSettings return empty list");
        return false;
    }

    private static Map<String, String> getGsettingsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "/usr/bin/gsettings list-recursively org.gnome.system.proxy";
        try {
            BufferedReader bufferedReader = GnomeNetworkProxy.executeCommand(string);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String string3 = GsettingsNetworkProxy.getKey(string2).toLowerCase();
                if (string3 != null && !string3.isEmpty()) {
                    String string4 = GsettingsNetworkProxy.getValue(string2);
                    hashMap.put(string3, string4);
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Cannot read line: " + string, iOException);
        }
        return hashMap;
    }

    private static String getKey(String string) {
        String[] stringArray = string.split(SPACE);
        if (stringArray.length >= 2) {
            return stringArray[0] + DOT + stringArray[1];
        }
        return null;
    }

    private static String getValue(String string) {
        String[] stringArray = string.split(SPACE);
        if (stringArray.length > 2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 2; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
            }
            return stringBuilder.toString().replaceAll(SINGLE_QUOTE, EMPTY_STRING);
        }
        return null;
    }

    private static String[] getNoProxyHosts(String string) {
        if (string != null && !string.isEmpty()) {
            if (string.startsWith(SQ_BRACKET_LEFT)) {
                string = string.substring(1);
            }
            if (string.endsWith(SQ_BRACKET_RIGHT)) {
                string = string.substring(0, string.length() - 1);
            }
            return string.split(COLON);
        }
        return new String[0];
    }
}

