/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.named.support.FileSystemFriendly;

@Singleton
@Named(value="file-gav")
public class FileGAVNameMapper
implements NameMapper,
FileSystemFriendly {
    public static final String NAME = "file-gav";
    private static final String LOCK_SUFFIX = ".resolverlock";
    private static final char SEPARATOR = '~';
    private final ConcurrentMap<String, Path> baseDirs = new ConcurrentHashMap<String, Path>();

    public TreeSet<String> nameLocks(RepositorySystemSession session2, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        File localRepositoryBasedir = session2.getLocalRepository().getBasedir();
        Path baseDir = this.baseDirs.computeIfAbsent(localRepositoryBasedir.getPath(), k -> {
            try {
                return new File(localRepositoryBasedir, ".locks").getCanonicalFile().toPath();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        });
        TreeSet<String> paths = new TreeSet<String>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                paths.add(this.getPath(baseDir, artifact) + LOCK_SUFFIX);
            }
        }
        if (metadatas != null) {
            for (Metadata metadata : metadatas) {
                paths.add(this.getPath(baseDir, metadata) + LOCK_SUFFIX);
            }
        }
        return paths;
    }

    private String getPath(Path baseDir, Artifact artifact) {
        String path2 = artifact.getGroupId() + '~' + artifact.getArtifactId() + '~' + artifact.getBaseVersion();
        return baseDir.resolve(path2).toAbsolutePath().toString();
    }

    private String getPath(Path baseDir, Metadata metadata) {
        String path2 = "";
        if (metadata.getGroupId().length() > 0) {
            path2 = path2 + metadata.getGroupId();
            if (metadata.getArtifactId().length() > 0) {
                path2 = path2 + '~' + metadata.getArtifactId();
                if (metadata.getVersion().length() > 0) {
                    path2 = path2 + '~' + metadata.getVersion();
                }
            }
        }
        return baseDir.resolve(path2).toAbsolutePath().toString();
    }
}

