/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTreeNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Date;
import java.util.List;
import utilities.util.FileUtilities;

public class FSBFileNode
extends FSBNode {
    protected GFile file;
    protected boolean isEncrypted;
    protected boolean hasPassword;
    protected String symlinkDest;
    protected long lastModified;
    protected String filenameExtOverride;

    FSBFileNode(GFile file) {
        super(file.getFSRL().getName());
        this.file = file;
    }

    @Override
    public void init(TaskMonitor monitor) {
        this.updateFileProps(monitor);
    }

    @Override
    public FSRL getFSRL() {
        return this.file.getFSRL();
    }

    @Override
    public GFile getGFile() {
        return this.file;
    }

    public boolean isLeaf() {
        return true;
    }

    @Override
    public String getToolTip() {
        if (this.symlinkDest != null) {
            return "%s \u2192 %s".formatted(this.getName(), this.symlinkDest);
        }
        long flen = this.file.getLength();
        String flenStr = flen >= 0L ? " - " + FileUtilities.formatLength((long)flen) : "";
        String lastModStr = this.lastModified > 0L ? " - " + FSUtilities.formatFSTimestamp(new Date(this.lastModified)) : "";
        String pwInfo = this.isEncrypted && !this.hasPassword ? " (missing password)" : "";
        return this.getName() + flenStr + lastModStr + pwInfo;
    }

    public boolean isSymlink() {
        return this.symlinkDest != null;
    }

    public String getFilenameExtOverride() {
        return this.filenameExtOverride;
    }

    @Override
    public String getFileExtension() {
        return this.filenameExtOverride != null && !this.filenameExtOverride.isEmpty() ? this.filenameExtOverride : super.getFileExtension();
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    private void updateFileProps(TaskMonitor monitor) {
        FileAttributes fattrs = this.file.getFilesystem().getFileAttributes(this.file, monitor);
        this.isEncrypted = fattrs.get(FileAttributeType.IS_ENCRYPTED_ATTR, Boolean.class, false);
        this.hasPassword = fattrs.get(FileAttributeType.HAS_GOOD_PASSWORD_ATTR, Boolean.class, false);
        this.symlinkDest = fattrs.get(FileAttributeType.SYMLINK_DEST_ATTR, String.class, null);
        Date lastModDate = fattrs.get(FileAttributeType.MODIFIED_DATE_ATTR, Date.class, null);
        this.lastModified = lastModDate != null ? lastModDate.getTime() : 0L;
        this.filenameExtOverride = fattrs.get(FileAttributeType.FILENAME_EXT_OVERRIDE, String.class, null);
    }

    @Override
    public void refreshNode(TaskMonitor monitor) throws CancelledException {
        boolean wasMissingPassword = this.hasMissingPassword();
        this.updateFileProps(monitor);
        if (wasMissingPassword != this.hasMissingPassword()) {
            this.getFSBRootNode().setCryptoStatusUpdated(true);
        }
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        return List.of();
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public boolean hasMissingPassword() {
        return this.isEncrypted && !this.hasPassword;
    }

    @Override
    public FSRL getLoadableFSRL() {
        return this.getFSRL();
    }
}

