/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.userdump;

import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.file.formats.dump.DumpData;
import ghidra.file.formats.dump.DumpFile;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.cmd.ModuleToPeHelper;
import ghidra.file.formats.dump.userdump.DebugInfo;
import ghidra.file.formats.dump.userdump.MemoryInfo;
import ghidra.file.formats.dump.userdump.Module;
import ghidra.file.formats.dump.userdump.Thread;
import ghidra.file.formats.dump.userdump.UserdumpFileHeader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class Userdump
extends DumpFile {
    public static final int SIGNATURE = 1380275029;
    UserdumpFileHeader header;
    private boolean createBlocks;

    public Userdump(DumpFileReader reader, ProgramBasedDataTypeManager dtm, List<Option> options, TaskMonitor monitor) {
        super(reader, dtm, options, monitor);
        this.program.setExecutableFormat("Portable Executable (PE)");
        this.initManagerList(null);
        this.createBlocks = OptionUtils.getBooleanOptionValue((String)"Create Memory Blocks", options, (boolean)true);
        try {
            this.header = new UserdumpFileHeader(reader, 0L);
            this.data.add(new DumpData(0L, this.header.toDataType()));
            this.buildStructures();
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)e.getMessage());
        }
    }

    public UserdumpFileHeader getFileHeader() {
        return this.header;
    }

    private void buildStructures() throws Exception {
        DataType dt = this.header.toDataType();
        this.data.add(new DumpData(0L, "DumpHeader", dt.getLength()));
        long regionOffset = this.header.getMemoryRegionOffset();
        this.addInteriorAddressObject("DumpHeader", 0L, 0L, regionOffset);
        long blocksLength = this.reader.length() - regionOffset;
        this.addInteriorAddressObject("RawBlocks", regionOffset, this.header.getMemoryRegionOffset(), blocksLength);
        CategoryPath path = new CategoryPath("/winnt.h");
        long offset = this.header.getThreadOffset();
        DataType ctxt = this.getTypeFromArchive(path, "CONTEXT");
        if (ctxt != null) {
            ArrayDataType actxt = new ArrayDataType(ctxt, this.header.getThreadCount(), ctxt.getLength());
            this.data.add(new DumpData(offset, (DataType)actxt, "THREAD_CONTEXTS", false, true));
            for (int t = 0; t < this.header.getThreadCount(); ++t) {
                this.setProgramContext(offset + (long)(t * ctxt.getLength()), ctxt, Integer.toHexString(t));
            }
        }
        long start = offset = this.header.getThreadStateOffset();
        this.reader.setPointerIndex(offset);
        for (int i = 0; i < this.header.getThreadCount(); ++i) {
            Thread t = new Thread(this.reader, offset);
            String tid = Integer.toHexString(t.getThreadId());
            dt = t.toDataType();
            long stackOffset = t.getStackRVA();
            if (this.createBlocks && stackOffset != 0L) {
                this.addInteriorAddressObject("ThreadStack_" + tid, stackOffset, t.getStackStartOfMemoryRange(), t.getStackDataSize());
            }
            offset += (long)dt.getLength();
        }
        ArrayDataType athreads = new ArrayDataType(dt, this.header.getThreadCount(), 80);
        this.data.add(new DumpData(start, (DataType)athreads, "THREAD_INFO", false, true));
        start = offset = this.header.getModuleOffset();
        StructureDataType modulesDT = new StructureDataType("MODULE_INFO", 0);
        for (int i = 0; i < this.header.getModuleCount(); ++i) {
            Module m = new Module(this.reader, offset);
            dt = m.toDataType();
            modulesDT.add(dt, dt.getLength(), m.getModuleName(), null);
            this.addModule(m.getModuleName(), m.getModuleBase(), i, m.getModuleSize());
            this.addExteriorAddressObject(m.getModuleName(), 0L, m.getModuleBase(), m.getModuleSize());
            offset += (long)dt.getLength();
        }
        this.data.add(new DumpData(start, (DataType)modulesDT, "MODULE_INFO", false, false));
        long rva = this.header.getMemoryRegionOffset();
        start = offset = this.header.getMemoryDescriptorOffset();
        StructureDataType blocks = new StructureDataType("MEMORY_BLOCKS", 0);
        for (int i = 0; i < this.header.getMemoryRegionCount(); ++i) {
            MemoryInfo minfo = new MemoryInfo(this.reader, offset);
            dt = minfo.toDataType();
            long regionSize = minfo.getRegionSize();
            if (this.createBlocks) {
                this.addInteriorAddressObject("Memory", rva, minfo.getBaseAddress(), regionSize);
            }
            rva += regionSize;
            offset += (long)dt.getLength();
        }
        ArrayDataType ainfo = new ArrayDataType(dt, this.header.getMemoryRegionCount(), dt.getLength());
        this.data.add(new DumpData(start, (DataType)ainfo, "MEMORY_INFO", false, true));
        this.data.add(new DumpData(regionOffset, (DataType)blocks, "MEMORY_BLOCKS", false, true));
        offset = this.header.getDebugEventOffset();
        DebugInfo debugInfo = new DebugInfo(this.reader, offset);
        this.data.add(new DumpData(offset, debugInfo.toDataType(), "DEBUG_EVENT_INFO", false, true));
        this.processId = debugInfo.getProcessId();
        this.threadId = debugInfo.getThreadId();
        this.addProcess(this.processId, "TARGET", 0);
        this.addThread(this.processId, this.threadId, 0);
    }

    public static String getMachineType(DumpFileReader reader) throws IOException {
        UserdumpFileHeader header = new UserdumpFileHeader(reader, 0L);
        return Integer.toHexString(header.getMachineImageType());
    }

    @Override
    public void analyze(TaskMonitor monitor) {
        boolean analyzeEmbeddedObjects = OptionUtils.getBooleanOptionValue((String)"Analyze Embedded Executables (interactive)", (List)this.options, (boolean)ANALYZE_EMBEDDED_OBJECTS_OPTION_DEFAULT);
        if (analyzeEmbeddedObjects) {
            ModuleToPeHelper.queryModules(this.program, monitor);
        }
    }

    public static Collection<? extends Option> getDefaultOptions(DumpFileReader reader) {
        return DumpFile.getDefaultOptions(reader);
    }
}

