import { Strategy as PassportStrategy } from "passport-strategy";
import { SAML } from "@node-saml/node-saml";
import { PassportSamlConfig } from "./types";
import { AuthenticateOptions, RequestWithUser, VerifyWithoutRequest, VerifyWithRequest } from "./types";
import { Request } from "express";
export declare abstract class AbstractStrategy extends PassportStrategy {
    static readonly newSamlProviderOnConstruct: boolean;
    name: string;
    _signonVerify: VerifyWithRequest | VerifyWithoutRequest;
    _logoutVerify: VerifyWithRequest | VerifyWithoutRequest;
    _saml: SAML | undefined;
    _passReqToCallback?: boolean;
    constructor(options: PassportSamlConfig, signonVerify: VerifyWithRequest, logoutVerify: VerifyWithRequest);
    constructor(options: PassportSamlConfig, signonVerify: VerifyWithoutRequest, logoutVerify: VerifyWithoutRequest);
    authenticate(req: Request, options: AuthenticateOptions): void;
    logout(req: RequestWithUser, callback: (err: Error | null, url?: string | null) => void): void;
    protected _generateServiceProviderMetadata(decryptionCert: string | null, signingCert?: string | string[] | null): string;
    error(err: Error): void;
    redirect(url: string, status?: number): void;
    success(user: unknown, info?: unknown): void;
}
export declare class Strategy extends AbstractStrategy {
    static readonly newSamlProviderOnConstruct = true;
    generateServiceProviderMetadata(decryptionCert: string | null, signingCert?: string | string[] | null): string;
}
