/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams.assignor;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.coordinator.group.streams.assignor.AssignmentMemberSpec;
import org.apache.kafka.coordinator.group.streams.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.streams.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.streams.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.streams.assignor.TaskAssignor;
import org.apache.kafka.coordinator.group.streams.assignor.TaskAssignorException;
import org.apache.kafka.coordinator.group.streams.assignor.TopologyDescriber;

public class MockAssignor
implements TaskAssignor {
    public static final String MOCK_ASSIGNOR_NAME = "mock";

    @Override
    public String name() {
        return MOCK_ASSIGNOR_NAME;
    }

    @Override
    public GroupAssignment assign(GroupSpec groupSpec, TopologyDescriber topologyDescriber) throws TaskAssignorException {
        HashMap<String, MemberAssignment> newTargetAssignment = new HashMap<String, MemberAssignment>();
        HashMap<String, String[]> subtopologyToActiveMember = new HashMap<String, String[]>();
        for (String string : topologyDescriber.subtopologies()) {
            int numberOfPartitions = topologyDescriber.maxNumInputPartitions(string);
            subtopologyToActiveMember.put(string, new String[numberOfPartitions]);
        }
        for (Map.Entry entry : groupSpec.members().entrySet()) {
            String memberId2 = (String)entry.getKey();
            AssignmentMemberSpec memberSpec = (AssignmentMemberSpec)entry.getValue();
            HashMap<String, Set<Integer>> activeTasks = new HashMap<String, Set<Integer>>(memberSpec.activeTasks());
            newTargetAssignment.put(memberId2, new MemberAssignment(activeTasks, new HashMap<String, Set<Integer>>(), new HashMap<String, Set<Integer>>()));
            for (Map.Entry entry2 : activeTasks.entrySet()) {
                String subtopologyId = (String)entry2.getKey();
                Set taskIds = (Set)entry2.getValue();
                String[] activeMembers = (String[])subtopologyToActiveMember.get(subtopologyId);
                Iterator iterator = taskIds.iterator();
                while (iterator.hasNext()) {
                    int taskId = (Integer)iterator.next();
                    if (activeMembers[taskId] != null) {
                        throw new TaskAssignorException("Task " + taskId + " of subtopology " + subtopologyId + " is assigned to multiple members");
                    }
                    activeMembers[taskId] = memberId2;
                }
            }
        }
        PriorityQueue<MemberAndTaskCount> memberAndTaskCount = new PriorityQueue<MemberAndTaskCount>(Comparator.comparingInt(m -> m.taskCount));
        memberAndTaskCount.addAll(newTargetAssignment.keySet().stream().map(memberId -> new MemberAndTaskCount((String)memberId, ((MemberAssignment)newTargetAssignment.get(memberId)).activeTasks().values().stream().mapToInt(Set::size).sum())).collect(Collectors.toSet()));
        for (Map.Entry entry : subtopologyToActiveMember.entrySet()) {
            String subtopologyId = (String)entry.getKey();
            String[] activeMembers = (String[])entry.getValue();
            for (int i = 0; i < activeMembers.length; ++i) {
                if (activeMembers[i] != null) continue;
                MemberAndTaskCount m2 = memberAndTaskCount.poll();
                if (m2 == null) {
                    throw new TaskAssignorException("No member available to assign task " + i + " of subtopology " + subtopologyId);
                }
                ((MemberAssignment)newTargetAssignment.get(m2.memberId)).activeTasks().computeIfAbsent(subtopologyId, k -> new HashSet()).add(i);
                activeMembers[i] = m2.memberId;
                memberAndTaskCount.add(new MemberAndTaskCount(m2.memberId, m2.taskCount + 1));
            }
        }
        return new GroupAssignment(newTargetAssignment);
    }

    private record MemberAndTaskCount(String memberId, int taskCount) {
    }
}

