/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.ExistingUserInfo;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public class IdpConfirmLinkAuthenticator
extends AbstractIdpAuthenticator {
    @Override
    protected void authenticateImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        String existingUserInfo = authSession.getAuthNote("EXISTING_USER_INFO");
        if (existingUserInfo == null) {
            ServicesLogger.LOGGER.noDuplicationDetected();
            context.attempted();
            return;
        }
        boolean hideReviewButton = authSession.getExecutionStatus().entrySet().stream().filter(entry -> CommonClientSessionModel.ExecutionStatus.SUCCESS.equals(entry.getValue())).map(entry -> context.getRealm().getAuthenticationExecutionById((String)entry.getKey())).filter(exec -> "idp-review-profile".equals(exec.getAuthenticator())).findAny().isEmpty();
        ExistingUserInfo duplicationInfo = ExistingUserInfo.deserialize(existingUserInfo);
        Response challenge = context.form().setStatus(Response.Status.OK).setAttribute("identityProviderBrokerCtx", (Object)brokerContext).setAttribute("hideReviewButton", (Object)(hideReviewButton ? Boolean.TRUE : null)).setError("federatedIdentityConfirmLinkMessage", new Object[]{duplicationInfo.getDuplicateAttributeName(), duplicationInfo.getDuplicateAttributeValue()}).createIdpLinkConfirmLinkPage();
        context.challenge(challenge);
    }

    @Override
    protected void actionImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String action = (String)formData.getFirst((Object)"submitAction");
        if (action != null && action.equals("updateProfile")) {
            context.resetFlow(() -> {
                AuthenticationSessionModel authSession = context.getAuthenticationSession();
                serializedCtx.saveToAuthenticationSession(authSession, "BROKERED_CONTEXT");
                authSession.setAuthNote("ENFORCE_UPDATE_PROFILE", "true");
            });
        } else if (action != null && action.equals("linkAccount")) {
            context.success();
        } else {
            throw new AuthenticationFlowException("Unknown action: " + action, AuthenticationFlowError.INTERNAL_ERROR);
        }
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return false;
    }
}

