import { RemoteRoom } from "matrix-appservice-bridge";
import { IrcServer } from "../irc/IrcServer";
/**
 * Validate that a channel name is in the correct form.
 * NOTE: This accepts both # and & as channel prefixes.
 * @param channel Channel name
 * @returns True if the channel is valid, or false otherwise.
 */
export declare function validateChannelName(channel: string): boolean;
export declare class IrcRoom extends RemoteRoom {
    readonly server: IrcServer;
    readonly channel: string;
    /**
     * Construct a new IRC room.
     * @constructor
     * @param {IrcServer} server : The IRC server which contains this room.
     * @param {String} channel : The channel this room represents.
     */
    constructor(server: IrcServer, channel: string);
    getDomain(): string;
    getServer(): IrcServer;
    getChannel(): string;
    getType(): "channel" | "pm";
    static fromRemoteRoom(server: IrcServer, remoteRoom: RemoteRoom): IrcRoom;
    static createId(server: {
        domain: string;
    }, channel: string): string;
}
