"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsPlugin = NotificationsPlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function NotificationsPlugin(Client, config, components) {
  const clientAction = components.clientAction.factory;
  Client.prototype.notifications = components.clientAction.namespaceFactory();
  const notifications = Client.prototype.notifications.prototype;
  notifications.getConfigs = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.CONFIGS
    },
    method: 'GET'
  });
  notifications.createConfig = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.CONFIGS
    },
    method: 'POST',
    needBody: true
  });
  notifications.getConfigById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.CONFIGS}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  notifications.deleteConfigs = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.CONFIGS
    },
    params: {
      config_id_list: {
        type: 'list',
        required: true
      }
    },
    method: 'DELETE'
  });
  notifications.updateConfigById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.CONFIGS}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'PUT',
    needBody: true
  });
  notifications.getEventById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.EVENTS}/<%=eventId%>`,
      req: {
        eventId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  notifications.sendTestMessage = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.TEST_MESSAGE}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  notifications.getServerFeatures = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.FEATURES
    },
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29tbW9uIiwicmVxdWlyZSIsIk5vdGlmaWNhdGlvbnNQbHVnaW4iLCJDbGllbnQiLCJjb25maWciLCJjb21wb25lbnRzIiwiY2xpZW50QWN0aW9uIiwiZmFjdG9yeSIsInByb3RvdHlwZSIsIm5vdGlmaWNhdGlvbnMiLCJuYW1lc3BhY2VGYWN0b3J5IiwiZ2V0Q29uZmlncyIsInVybCIsImZtdCIsIk9QRU5TRUFSQ0hfQVBJIiwiQ09ORklHUyIsIm1ldGhvZCIsImNyZWF0ZUNvbmZpZyIsIm5lZWRCb2R5IiwiZ2V0Q29uZmlnQnlJZCIsInJlcSIsImNvbmZpZ0lkIiwidHlwZSIsInJlcXVpcmVkIiwiZGVsZXRlQ29uZmlncyIsInBhcmFtcyIsImNvbmZpZ19pZF9saXN0IiwidXBkYXRlQ29uZmlnQnlJZCIsImdldEV2ZW50QnlJZCIsIkVWRU5UUyIsImV2ZW50SWQiLCJzZW5kVGVzdE1lc3NhZ2UiLCJURVNUX01FU1NBR0UiLCJnZXRTZXJ2ZXJGZWF0dXJlcyIsIkZFQVRVUkVTIl0sInNvdXJjZXMiOlsibm90aWZpY2F0aW9uc1BsdWdpbi50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IE9QRU5TRUFSQ0hfQVBJIH0gZnJvbSAnLi4vLi4vY29tbW9uJztcblxuZXhwb3J0IGZ1bmN0aW9uIE5vdGlmaWNhdGlvbnNQbHVnaW4oQ2xpZW50OiBhbnksIGNvbmZpZzogYW55LCBjb21wb25lbnRzOiBhbnkpIHtcbiAgY29uc3QgY2xpZW50QWN0aW9uID0gY29tcG9uZW50cy5jbGllbnRBY3Rpb24uZmFjdG9yeTtcblxuICBDbGllbnQucHJvdG90eXBlLm5vdGlmaWNhdGlvbnMgPSBjb21wb25lbnRzLmNsaWVudEFjdGlvbi5uYW1lc3BhY2VGYWN0b3J5KCk7XG4gIGNvbnN0IG5vdGlmaWNhdGlvbnMgPSBDbGllbnQucHJvdG90eXBlLm5vdGlmaWNhdGlvbnMucHJvdG90eXBlO1xuXG4gIG5vdGlmaWNhdGlvbnMuZ2V0Q29uZmlncyA9IGNsaWVudEFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IE9QRU5TRUFSQ0hfQVBJLkNPTkZJR1MsXG4gICAgfSxcbiAgICBtZXRob2Q6ICdHRVQnLFxuICB9KTtcblxuICBub3RpZmljYXRpb25zLmNyZWF0ZUNvbmZpZyA9IGNsaWVudEFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IE9QRU5TRUFSQ0hfQVBJLkNPTkZJR1MsXG4gICAgfSxcbiAgICBtZXRob2Q6ICdQT1NUJyxcbiAgICBuZWVkQm9keTogdHJ1ZSxcbiAgfSk7XG5cbiAgbm90aWZpY2F0aW9ucy5nZXRDb25maWdCeUlkID0gY2xpZW50QWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogYCR7T1BFTlNFQVJDSF9BUEkuQ09ORklHU30vPCU9Y29uZmlnSWQlPmAsXG4gICAgICByZXE6IHtcbiAgICAgICAgY29uZmlnSWQ6IHtcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICByZXF1aXJlZDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBtZXRob2Q6ICdHRVQnLFxuICB9KTtcblxuICBub3RpZmljYXRpb25zLmRlbGV0ZUNvbmZpZ3MgPSBjbGllbnRBY3Rpb24oe1xuICAgIHVybDoge1xuICAgICAgZm10OiBPUEVOU0VBUkNIX0FQSS5DT05GSUdTLFxuICAgIH0sXG4gICAgcGFyYW1zOiB7XG4gICAgICBjb25maWdfaWRfbGlzdDoge1xuICAgICAgICB0eXBlOiAnbGlzdCcsXG4gICAgICAgIHJlcXVpcmVkOiB0cnVlLFxuICAgICAgfSxcbiAgICB9LFxuICAgIG1ldGhvZDogJ0RFTEVURScsXG4gIH0pO1xuXG4gIG5vdGlmaWNhdGlvbnMudXBkYXRlQ29uZmlnQnlJZCA9IGNsaWVudEFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke09QRU5TRUFSQ0hfQVBJLkNPTkZJR1N9LzwlPWNvbmZpZ0lkJT5gLFxuICAgICAgcmVxOiB7XG4gICAgICAgIGNvbmZpZ0lkOiB7XG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgcmVxdWlyZWQ6IHRydWUsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0sXG4gICAgbWV0aG9kOiAnUFVUJyxcbiAgICBuZWVkQm9keTogdHJ1ZSxcbiAgfSk7XG5cbiAgbm90aWZpY2F0aW9ucy5nZXRFdmVudEJ5SWQgPSBjbGllbnRBY3Rpb24oe1xuICAgIHVybDoge1xuICAgICAgZm10OiBgJHtPUEVOU0VBUkNIX0FQSS5FVkVOVFN9LzwlPWV2ZW50SWQlPmAsXG4gICAgICByZXE6IHtcbiAgICAgICAgZXZlbnRJZDoge1xuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgIHJlcXVpcmVkOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9LFxuICAgIG1ldGhvZDogJ0dFVCcsXG4gIH0pO1xuXG4gIG5vdGlmaWNhdGlvbnMuc2VuZFRlc3RNZXNzYWdlID0gY2xpZW50QWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogYCR7T1BFTlNFQVJDSF9BUEkuVEVTVF9NRVNTQUdFfS88JT1jb25maWdJZCU+YCxcbiAgICAgIHJlcToge1xuICAgICAgICBjb25maWdJZDoge1xuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgIHJlcXVpcmVkOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9LFxuICAgIG1ldGhvZDogJ1BPU1QnLFxuICB9KTtcblxuICBub3RpZmljYXRpb25zLmdldFNlcnZlckZlYXR1cmVzID0gY2xpZW50QWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogT1BFTlNFQVJDSF9BUEkuRkVBVFVSRVMsXG4gICAgfSxcbiAgICBtZXRob2Q6ICdHRVQnLFxuICB9KTtcblxufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxPQUFBLEdBQUFDLE9BQUE7QUFMQTtBQUNBO0FBQ0E7QUFDQTs7QUFJTyxTQUFTQyxtQkFBbUJBLENBQUNDLE1BQVcsRUFBRUMsTUFBVyxFQUFFQyxVQUFlLEVBQUU7RUFDN0UsTUFBTUMsWUFBWSxHQUFHRCxVQUFVLENBQUNDLFlBQVksQ0FBQ0MsT0FBTztFQUVwREosTUFBTSxDQUFDSyxTQUFTLENBQUNDLGFBQWEsR0FBR0osVUFBVSxDQUFDQyxZQUFZLENBQUNJLGdCQUFnQixDQUFDLENBQUM7RUFDM0UsTUFBTUQsYUFBYSxHQUFHTixNQUFNLENBQUNLLFNBQVMsQ0FBQ0MsYUFBYSxDQUFDRCxTQUFTO0VBRTlEQyxhQUFhLENBQUNFLFVBQVUsR0FBR0wsWUFBWSxDQUFDO0lBQ3RDTSxHQUFHLEVBQUU7TUFDSEMsR0FBRyxFQUFFQyxzQkFBYyxDQUFDQztJQUN0QixDQUFDO0lBQ0RDLE1BQU0sRUFBRTtFQUNWLENBQUMsQ0FBQztFQUVGUCxhQUFhLENBQUNRLFlBQVksR0FBR1gsWUFBWSxDQUFDO0lBQ3hDTSxHQUFHLEVBQUU7TUFDSEMsR0FBRyxFQUFFQyxzQkFBYyxDQUFDQztJQUN0QixDQUFDO0lBQ0RDLE1BQU0sRUFBRSxNQUFNO0lBQ2RFLFFBQVEsRUFBRTtFQUNaLENBQUMsQ0FBQztFQUVGVCxhQUFhLENBQUNVLGFBQWEsR0FBR2IsWUFBWSxDQUFDO0lBQ3pDTSxHQUFHLEVBQUU7TUFDSEMsR0FBRyxFQUFHLEdBQUVDLHNCQUFjLENBQUNDLE9BQVEsZ0JBQWU7TUFDOUNLLEdBQUcsRUFBRTtRQUNIQyxRQUFRLEVBQUU7VUFDUkMsSUFBSSxFQUFFLFFBQVE7VUFDZEMsUUFBUSxFQUFFO1FBQ1o7TUFDRjtJQUNGLENBQUM7SUFDRFAsTUFBTSxFQUFFO0VBQ1YsQ0FBQyxDQUFDO0VBRUZQLGFBQWEsQ0FBQ2UsYUFBYSxHQUFHbEIsWUFBWSxDQUFDO0lBQ3pDTSxHQUFHLEVBQUU7TUFDSEMsR0FBRyxFQUFFQyxzQkFBYyxDQUFDQztJQUN0QixDQUFDO0lBQ0RVLE1BQU0sRUFBRTtNQUNOQyxjQUFjLEVBQUU7UUFDZEosSUFBSSxFQUFFLE1BQU07UUFDWkMsUUFBUSxFQUFFO01BQ1o7SUFDRixDQUFDO0lBQ0RQLE1BQU0sRUFBRTtFQUNWLENBQUMsQ0FBQztFQUVGUCxhQUFhLENBQUNrQixnQkFBZ0IsR0FBR3JCLFlBQVksQ0FBQztJQUM1Q00sR0FBRyxFQUFFO01BQ0hDLEdBQUcsRUFBRyxHQUFFQyxzQkFBYyxDQUFDQyxPQUFRLGdCQUFlO01BQzlDSyxHQUFHLEVBQUU7UUFDSEMsUUFBUSxFQUFFO1VBQ1JDLElBQUksRUFBRSxRQUFRO1VBQ2RDLFFBQVEsRUFBRTtRQUNaO01BQ0Y7SUFDRixDQUFDO0lBQ0RQLE1BQU0sRUFBRSxLQUFLO0lBQ2JFLFFBQVEsRUFBRTtFQUNaLENBQUMsQ0FBQztFQUVGVCxhQUFhLENBQUNtQixZQUFZLEdBQUd0QixZQUFZLENBQUM7SUFDeENNLEdBQUcsRUFBRTtNQUNIQyxHQUFHLEVBQUcsR0FBRUMsc0JBQWMsQ0FBQ2UsTUFBTyxlQUFjO01BQzVDVCxHQUFHLEVBQUU7UUFDSFUsT0FBTyxFQUFFO1VBQ1BSLElBQUksRUFBRSxRQUFRO1VBQ2RDLFFBQVEsRUFBRTtRQUNaO01BQ0Y7SUFDRixDQUFDO0lBQ0RQLE1BQU0sRUFBRTtFQUNWLENBQUMsQ0FBQztFQUVGUCxhQUFhLENBQUNzQixlQUFlLEdBQUd6QixZQUFZLENBQUM7SUFDM0NNLEdBQUcsRUFBRTtNQUNIQyxHQUFHLEVBQUcsR0FBRUMsc0JBQWMsQ0FBQ2tCLFlBQWEsZ0JBQWU7TUFDbkRaLEdBQUcsRUFBRTtRQUNIQyxRQUFRLEVBQUU7VUFDUkMsSUFBSSxFQUFFLFFBQVE7VUFDZEMsUUFBUSxFQUFFO1FBQ1o7TUFDRjtJQUNGLENBQUM7SUFDRFAsTUFBTSxFQUFFO0VBQ1YsQ0FBQyxDQUFDO0VBRUZQLGFBQWEsQ0FBQ3dCLGlCQUFpQixHQUFHM0IsWUFBWSxDQUFDO0lBQzdDTSxHQUFHLEVBQUU7TUFDSEMsR0FBRyxFQUFFQyxzQkFBYyxDQUFDb0I7SUFDdEIsQ0FBQztJQUNEbEIsTUFBTSxFQUFFO0VBQ1YsQ0FBQyxDQUFDO0FBRUoifQ==