/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class TokenFilter
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TokenFilter> _DESERIALIZER = JsonpDeserializer.lazy(TokenFilter::buildTokenFilterDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private TokenFilter(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private TokenFilter(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TokenFilter of(Function<Builder, ObjectBuilder<TokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isDefinition() {
        return this._kind == Kind.Definition;
    }

    public TokenFilterDefinition definition() {
        return (TokenFilterDefinition)TaggedUnionUtils.get(this, Kind.Definition);
    }

    public boolean isName() {
        return this._kind == Kind.Name;
    }

    public String name() {
        return (String)TaggedUnionUtils.get(this, Kind.Name);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 1: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<TokenFilter> buildTokenFilterDeserializer() {
        return new UnionDeserializer.Builder<TokenFilter, Kind, Object>(TokenFilter::new, false).addMember(Kind.Definition, TokenFilterDefinition._DESERIALIZER).addMember(Kind.Name, JsonpDeserializer.stringDeserializer()).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenFilter other = (TokenFilter)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TokenFilter> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(TokenFilter o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<TokenFilter> definition(TokenFilterDefinition v) {
            this._kind = Kind.Definition;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilter> definition(Function<TokenFilterDefinition.Builder, ObjectBuilder<TokenFilterDefinition>> fn) {
            return this.definition(fn.apply(new TokenFilterDefinition.Builder()).build());
        }

        public ObjectBuilder<TokenFilter> name(String v) {
            this._kind = Kind.Name;
            this._value = v;
            return this;
        }

        @Override
        public TokenFilter build() {
            this._checkSingleUse();
            return new TokenFilter(this);
        }
    }

    public static enum Kind {
        Definition,
        Name;

    }
}

