/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterStateOverallStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterStateOverallStats> {
    @Nullable
    private final Long failedCount;
    @Nullable
    private final Long totalTimeInMillis;
    @Nullable
    private final Long updateCount;
    public static final JsonpDeserializer<ClusterStateOverallStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterStateOverallStats::setupClusterStateOverallStatsDeserializer);

    private ClusterStateOverallStats(Builder builder) {
        this.failedCount = builder.failedCount;
        this.totalTimeInMillis = builder.totalTimeInMillis;
        this.updateCount = builder.updateCount;
    }

    public static ClusterStateOverallStats of(Function<Builder, ObjectBuilder<ClusterStateOverallStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long failedCount() {
        return this.failedCount;
    }

    @Nullable
    public final Long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Nullable
    public final Long updateCount() {
        return this.updateCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.failedCount != null) {
            generator.writeKey("failed_count");
            generator.write(this.failedCount.longValue());
        }
        if (this.totalTimeInMillis != null) {
            generator.writeKey("total_time_in_millis");
            generator.write(this.totalTimeInMillis.longValue());
        }
        if (this.updateCount != null) {
            generator.writeKey("update_count");
            generator.write(this.updateCount.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterStateOverallStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failedCount, JsonpDeserializer.longDeserializer(), "failed_count");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
        op.add(Builder::updateCount, JsonpDeserializer.longDeserializer(), "update_count");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.failedCount);
        result = 31 * result + Objects.hashCode(this.totalTimeInMillis);
        result = 31 * result + Objects.hashCode(this.updateCount);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateOverallStats other = (ClusterStateOverallStats)o;
        return Objects.equals(this.failedCount, other.failedCount) && Objects.equals(this.totalTimeInMillis, other.totalTimeInMillis) && Objects.equals(this.updateCount, other.updateCount);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterStateOverallStats> {
        @Nullable
        private Long failedCount;
        @Nullable
        private Long totalTimeInMillis;
        @Nullable
        private Long updateCount;

        public Builder() {
        }

        private Builder(ClusterStateOverallStats o) {
            this.failedCount = o.failedCount;
            this.totalTimeInMillis = o.totalTimeInMillis;
            this.updateCount = o.updateCount;
        }

        private Builder(Builder o) {
            this.failedCount = o.failedCount;
            this.totalTimeInMillis = o.totalTimeInMillis;
            this.updateCount = o.updateCount;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder failedCount(@Nullable Long value) {
            this.failedCount = value;
            return this;
        }

        @Nonnull
        public final Builder totalTimeInMillis(@Nullable Long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder updateCount(@Nullable Long value) {
            this.updateCount = value;
            return this;
        }

        @Override
        @Nonnull
        public ClusterStateOverallStats build() {
            this._checkSingleUse();
            return new ClusterStateOverallStats(this);
        }
    }
}

