/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ProcessMemoryStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ProcessMemoryStats> {
    @Nullable
    private final String totalVirtual;
    @Nullable
    private final Long totalVirtualInBytes;
    public static final JsonpDeserializer<ProcessMemoryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ProcessMemoryStats::setupProcessMemoryStatsDeserializer);

    private ProcessMemoryStats(Builder builder) {
        this.totalVirtual = builder.totalVirtual;
        this.totalVirtualInBytes = builder.totalVirtualInBytes;
    }

    public static ProcessMemoryStats of(Function<Builder, ObjectBuilder<ProcessMemoryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String totalVirtual() {
        return this.totalVirtual;
    }

    @Nullable
    public final Long totalVirtualInBytes() {
        return this.totalVirtualInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.totalVirtual != null) {
            generator.writeKey("total_virtual");
            generator.write(this.totalVirtual);
        }
        if (this.totalVirtualInBytes != null) {
            generator.writeKey("total_virtual_in_bytes");
            generator.write(this.totalVirtualInBytes.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupProcessMemoryStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::totalVirtual, JsonpDeserializer.stringDeserializer(), "total_virtual");
        op.add(Builder::totalVirtualInBytes, JsonpDeserializer.longDeserializer(), "total_virtual_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.totalVirtual);
        result = 31 * result + Objects.hashCode(this.totalVirtualInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessMemoryStats other = (ProcessMemoryStats)o;
        return Objects.equals(this.totalVirtual, other.totalVirtual) && Objects.equals(this.totalVirtualInBytes, other.totalVirtualInBytes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ProcessMemoryStats> {
        @Nullable
        private String totalVirtual;
        @Nullable
        private Long totalVirtualInBytes;

        public Builder() {
        }

        private Builder(ProcessMemoryStats o) {
            this.totalVirtual = o.totalVirtual;
            this.totalVirtualInBytes = o.totalVirtualInBytes;
        }

        private Builder(Builder o) {
            this.totalVirtual = o.totalVirtual;
            this.totalVirtualInBytes = o.totalVirtualInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder totalVirtual(@Nullable String value) {
            this.totalVirtual = value;
            return this;
        }

        @Nonnull
        public final Builder totalVirtualInBytes(@Nullable Long value) {
            this.totalVirtualInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public ProcessMemoryStats build() {
            this._checkSingleUse();
            return new ProcessMemoryStats(this);
        }
    }
}

