/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sns.model.Topic;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListTopicsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Topic> topics;
    private String nextToken;

    public List<Topic> getTopics() {
        if (this.topics == null) {
            this.topics = new SdkInternalList();
        }
        return this.topics;
    }

    public void setTopics(Collection<Topic> topics) {
        if (topics == null) {
            this.topics = null;
            return;
        }
        this.topics = new SdkInternalList(topics);
    }

    public ListTopicsResult withTopics(Topic ... topics) {
        if (this.topics == null) {
            this.setTopics((Collection<Topic>)new SdkInternalList(topics.length));
        }
        for (Topic ele : topics) {
            this.topics.add((Object)ele);
        }
        return this;
    }

    public ListTopicsResult withTopics(Collection<Topic> topics) {
        this.setTopics(topics);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTopicsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTopics() != null) {
            sb.append("Topics: ").append(this.getTopics()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsResult)) {
            return false;
        }
        ListTopicsResult other = (ListTopicsResult)obj;
        if (other.getTopics() == null ^ this.getTopics() == null) {
            return false;
        }
        if (other.getTopics() != null && !other.getTopics().equals(this.getTopics())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTopics() == null ? 0 : this.getTopics().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTopicsResult clone() {
        try {
            return (ListTopicsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

