/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;

public class PDDeviceGray
extends PDColorSpace {
    public static final String NAME = "DeviceGray";
    public static final String ABBREVIATED_NAME = "G";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumberOfComponents() throws IOException {
        return 1;
    }

    @Override
    protected ColorSpace createColorSpace() {
        return ColorSpace.getInstance(1003);
    }

    @Override
    public ColorModel createColorModel(int bpc) throws IOException {
        ColorModel colorModel = null;
        if (bpc == 8) {
            ColorSpace cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{bpc};
            colorModel = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        } else {
            int numEntries = 1 << bpc;
            byte[] indexedValues = new byte[numEntries];
            for (int i = 0; i < numEntries; ++i) {
                indexedValues[i] = (byte)(i * 255 / (numEntries - 1));
            }
            colorModel = new IndexColorModel(bpc, numEntries, indexedValues, indexedValues, indexedValues);
        }
        return colorModel;
    }
}

